(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9077,        430]*)
(*NotebookOutlinePosition[      9747,        453]*)
(*  CellTagsIndexPosition[      9703,        449]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Nachweis des Assoziativgesetzes bei gegebener Strukturtafel", "Title"],

Cell["Bernd Fiedler, Eichelbaumstr. 13, 04249 Leipzig", "Subtitle"],

Cell["November 2007", "Subtitle"],

Cell[CellGroupData[{

Cell["Tr\[ADoubleDot]germenge und Strukturtafel", "Section"],

Cell[TextData[{
  "Wir betrachten das Beispiel aus Aufgabe 3a) der Aufgaben zum 7. Seminar \
(",
  StyleBox["sem7_07INMI.pdf",
    FontWeight->"Bold"],
  ")."
}], "Text"],

Cell["Zun\[ADoubleDot]chst definieren wir die Tr\[ADoubleDot]germenge der \
Algebra:", "Text"],

Cell[CellGroupData[{

Cell["m = {a,b,c,d}", "Input"],

Cell[OutputFormData["\<\
{a, b, c, d}\
\>", "\<\
{a, b, c, d}\
\>"], "Output"]
}, Open  ]],

Cell["\<\
Die Multiplikation der Algebra wird durch die Strukturtafel gegeben:\
\>", "Text"],

Cell[CellGroupData[{

Cell["tab = {{a,b,c,d},{b,a,d,c},{c,d,a,b},{d,c,b,a}}", "Input"],

Cell["\<\
General::spell1: Possible spelling error: new symbol name \"tab\" is similar \
to existing symbol 
    \"Tab\". Mehr\[Ellipsis]\
\>", "Message"],

Cell[OutputFormData["\<\
{{a, b, c, d}, {b, a, d, c}, {c, d, a, b}, {d, c, b, a}}\
\>", "\<\
{{a, b, c, d}, {b, a, d, c}, {c, d, a, b}, {d, c, b, a}}\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[tab]", "Input"],

Cell[OutputFormData["\<\
{{a, b, c, d}, {b, a, d, c}, {c, d, a, b}, {d, c, b, a}}\
\>", "\<\
a   b   c   d

b   a   d   c

c   d   a   b

d   c   b   a\
\>"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Das Produkt der Algebra", "Section"],

Cell[TextData[{
  "Wir f\[UDoubleDot]hren nun ein Produkt ",
  StyleBox["prod",
    FontWeight->"Bold"],
  " ein, das die Elemente von ",
  StyleBox["m",
    FontWeight->"Bold"],
  " entsprechend der Strukturtafel ",
  StyleBox["tab",
    FontWeight->"Bold"],
  " multipliziert."
}], "Text"],

Cell["\<\
prod[x_,y_] := tab[[Position[m,x][[1,1]], Position[m,y][[1,1]] ]]\
\>", "Input"],

Cell["Wir f\[UDoubleDot]hren einige Testmultiplikationen aus:", "Text"],

Cell[CellGroupData[{

Cell["prod[a,b]", "Input"],

Cell[OutputFormData["\<\
b\
\>", "\<\
b\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["prod[b,c]", "Input"],

Cell[OutputFormData["\<\
d\
\>", "\<\
d\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["prod[b,b]", "Input"],

Cell[OutputFormData["\<\
a\
\>", "\<\
a\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["prod[b,d]", "Input"],

Cell[OutputFormData["\<\
c\
\>", "\<\
c\
\>"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Der Test auf G\[UDoubleDot]ltigkeit des Assoziativgesetzes", "Section"],

Cell["Wir definieren das Testtool.", "Text"],

Cell["\<\
test := Table[prod[prod[m[[i]],m[[j]]],m[[k]]] === \
prod[m[[i]],prod[m[[j]],m[[k]]]],
             {i,1,Length[m]},{j,1,Length[m]},{k,1,Length[m]}
             ]\
\>", "Input"],

Cell["Wir f\[UDoubleDot]hren den Test aus:", "Text"],

Cell[CellGroupData[{

Cell["test", "Input"],

Cell[OutputFormData["\<\
{{{True, True, True, True}, {True, True, True, True}, {True, True, True, \
True}, 
  {True, True, True, True}}, {{True, True, True, True}, {True, True, True, \
True}, 
  {True, True, True, True}, {True, True, True, True}}, 
 {{True, True, True, True}, {True, True, True, True}, {True, True, True, \
True}, 
  {True, True, True, True}}, {{True, True, True, True}, {True, True, True, \
True}, 
  {True, True, True, True}, {True, True, True, True}}}\
\>", "\<\
{{{True, True, True, True}, {True, True, True, True}, {True, True, True, \
True}, 
 
   {True, True, True, True}}, {{True, True, True, True}, {True, True, True, \
True}, 
 
   {True, True, True, True}, {True, True, True, True}}, 
 
  {{True, True, True, True}, {True, True, True, True}, {True, True, True, \
True}, 
 
   {True, True, True, True}}, {{True, True, True, True}, {True, True, True, \
True}, 
 
   {True, True, True, True}, {True, True, True, True}}}\
\>"], "Output"]
}, Open  ]],

Cell[TextData[{
  "Um nicht per Auge \[UDoubleDot]berpr\[UDoubleDot]fen zu \
m\[UDoubleDot]ssen, da\[SZ] nirgendwo ",
  StyleBox["False ",
    FontWeight->"Bold"],
  "auftritt, vereinfachen wir das Resultat von test mittels Flatten, Apply \
und And."
}], "Text"],

Cell["testresult := Apply[And,Flatten[test]]", "Input"],

Cell[CellGroupData[{

Cell["testresult", "Input"],

Cell[OutputFormData["\<\
True\
\>", "\<\
True\
\>"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Weitere Anwendung", "Section"],

Cell[CellGroupData[{

Cell["Aufgabe 3b)", "Subsection"],

Cell["\<\
Wir wenden testresult auf die Strukturtafel von Aufgabe 3b) an:\
\>", "Input"],

Cell[CellGroupData[{

Cell["tab = {{a,b,c,d},{b,a,a,c},{c,a,a,b},{d,c,b,a}}", "Input"],

Cell[OutputFormData["\<\
{{a, b, c, d}, {b, a, a, c}, {c, a, a, b}, {d, c, b, a}}\
\>", "\<\
{{a, b, c, d}, {b, a, a, c}, {c, a, a, b}, {d, c, b, a}}\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[tab]", "Input"],

Cell[OutputFormData["\<\
{{a, b, c, d}, {b, a, a, c}, {c, a, a, b}, {d, c, b, a}}\
\>", "\<\
a   b   c   d

b   a   a   c

c   a   a   b

d   c   b   a\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["testresult", "Input"],

Cell[OutputFormData["\<\
False\
\>", "\<\
False\
\>"], "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Strukturtafel der ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]]
}], "Subsection"],

Cell[TextData[{
  "Die ",
  Cell[BoxData[
      \(TraditionalForm\`S\_3\)]],
  " ist die Gruppe der 6 Permutationen der Zahlen 1,2,3. Wir wollen \
testresult auf die Strukturtafel (Gruppentafel) dieser Gruppe anwenden."
}], "Text"],

Cell["Die zugeh\[ODoubleDot]rige Tr\[ADoubleDot]germenge ist", "Text"],

Cell[CellGroupData[{

Cell["m = {e,a,b,c,u,v}", "Input"],

Cell[OutputFormData["\<\
{e, a, b, c, u, v}\
\>", "\<\
{e, a, b, c, u, v}\
\>"], "Output"]
}, Open  ]],

Cell["\<\
Hierbei sei 
e = (1),  a = (1,2), b = (1,3), c = (2,3), u = (1,2,3), v = (1,3,2)\
\>", "Text"],

Cell["Dann lautet die Strukturtafel", "Text"],

Cell[CellGroupData[{

Cell["\<\
tab = {
       {e,a,b,c,u,v},
       {a,e,v,u,c,b},
       {b,u,e,v,a,c},
       {c,v,u,e,b,a},
       {u,b,c,a,v,e},
       {v,c,a,b,e,u}
      }\
\>", "Input"],

Cell[OutputFormData["\<\
{{e, a, b, c, u, v}, {a, e, v, u, c, b}, {b, u, e, v, a, c}, {c, v, u, e, b, \
a}, 
 {u, b, c, a, v, e}, {v, c, a, b, e, u}}\
\>", "\<\
{{e, a, b, c, u, v}, {a, e, v, u, c, b}, {b, u, e, v, a, c}, {c, v, u, e, b, \
a}, 
 
  {u, b, c, a, v, e}, {v, c, a, b, e, u}}\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MatrixForm[tab]", "Input"],

Cell[OutputFormData["\<\
{{e, a, b, c, u, v}, {a, e, v, u, c, b}, {b, u, e, v, a, c}, {c, v, u, e, b, \
a}, 
 {u, b, c, a, v, e}, {v, c, a, b, e, u}}\
\>", "\<\
e   a   b   c   u   v

a   e   v   u   c   b

b   u   e   v   a   c

c   v   u   e   b   a

u   b   c   a   v   e

v   c   a   b   e   u\
\>"], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["testresult", "Input"],

Cell[OutputFormData["\<\
True\
\>", "\<\
True\
\>"], "Output"]
}, Open  ]],

Cell["\<\
Die Zahl der von test bzw. testresult hier \
\[UDoubleDot]berpr\[UDoubleDot]ften Relationen ist\
\>", "Text"],

Cell[CellGroupData[{

Cell["6^3", "Input"],

Cell[OutputFormData["\<\
216\
\>", "\<\
216\
\>"], "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 685}},
WindowToolbars->"EditBar",
WindowSize->{797, 527},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 76, 0, 150, "Title"],
Cell[1855, 55, 67, 0, 51, "Subtitle"],
Cell[1925, 57, 33, 0, 51, "Subtitle"],

Cell[CellGroupData[{
Cell[1983, 61, 60, 0, 73, "Section"],
Cell[2046, 63, 170, 6, 33, "Text"],
Cell[2219, 71, 94, 1, 33, "Text"],

Cell[CellGroupData[{
Cell[2338, 76, 30, 0, 30, "Input"],
Cell[2371, 78, 78, 4, 27, "Output"]
}, Open  ]],
Cell[2464, 85, 92, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[2581, 91, 64, 0, 30, "Input"],
Cell[2648, 93, 154, 4, 36, "Message"],
Cell[2805, 99, 166, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3008, 108, 32, 0, 30, "Input"],
Cell[3043, 110, 168, 10, 87, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[3260, 126, 42, 0, 43, "Section"],
Cell[3305, 128, 291, 11, 33, "Text"],
Cell[3599, 141, 90, 2, 30, "Input"],
Cell[3692, 145, 71, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[3788, 149, 26, 0, 30, "Input"],
Cell[3817, 151, 56, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3910, 160, 26, 0, 30, "Input"],
Cell[3939, 162, 56, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4032, 171, 26, 0, 30, "Input"],
Cell[4061, 173, 56, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4154, 182, 26, 0, 30, "Input"],
Cell[4183, 184, 56, 4, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[4288, 194, 77, 0, 43, "Section"],
Cell[4368, 196, 44, 0, 33, "Text"],
Cell[4415, 198, 187, 5, 66, "Input"],
Cell[4605, 205, 52, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[4682, 209, 21, 0, 30, "Input"],
Cell[4706, 211, 961, 27, 127, "Output"]
}, Open  ]],
Cell[5682, 241, 262, 7, 52, "Text"],
Cell[5947, 250, 55, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[6027, 254, 27, 0, 30, "Input"],
Cell[6057, 256, 62, 4, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[6168, 266, 36, 0, 43, "Section"],

Cell[CellGroupData[{
Cell[6229, 270, 33, 0, 38, "Subsection"],
Cell[6265, 272, 88, 2, 30, "Input"],

Cell[CellGroupData[{
Cell[6378, 278, 64, 0, 30, "Input"],
Cell[6445, 280, 166, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6648, 289, 32, 0, 30, "Input"],
Cell[6683, 291, 168, 10, 101, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6888, 306, 27, 0, 30, "Input"],
Cell[6918, 308, 64, 4, 27, "Output"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[7031, 318, 107, 4, 30, "Subsection"],
Cell[7141, 324, 231, 6, 52, "Text"],
Cell[7375, 332, 70, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[7470, 336, 34, 0, 30, "Input"],
Cell[7507, 338, 90, 4, 27, "Output"]
}, Open  ]],
Cell[7612, 345, 104, 3, 52, "Text"],
Cell[7719, 350, 45, 0, 33, "Text"],

Cell[CellGroupData[{
Cell[7789, 354, 171, 9, 156, "Input"],
Cell[7963, 365, 305, 9, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8305, 379, 32, 0, 30, "Input"],
Cell[8340, 381, 314, 16, 127, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8691, 402, 27, 0, 30, "Input"],
Cell[8721, 404, 62, 4, 27, "Output"]
}, Open  ]],
Cell[8798, 411, 119, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[8942, 418, 20, 0, 30, "Input"],
Cell[8965, 420, 60, 4, 27, "Output"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

